#include <pthread.h>

template<typename T>
class atomic
{
public:
    typedef T value_type;

private:
    pthread_mutex_t mutex;
    volatile value_type value;
    
public:
    atomic()
    {
        pthread_mutex_init(&mutex, NULL);
    }
    
    atomic(value_type val)
    {
        pthread_mutex_init(&mutex, NULL);
        pthread_mutex_lock(&mutex);
        value=val;
        pthread_mutex_unlock(&mutex);
    }
    
    ~atomic()
    {
        pthread_mutex_destroy(&mutex);
    }
    
    value_type get()
    {
        value_type tmp;
        pthread_mutex_lock(&mutex);
        tmp = value;
        pthread_mutex_unlock(&mutex);
        return tmp;
    }
    
    void set(value_type val)
    {
        pthread_mutex_lock(&mutex);
        value=val;
        pthread_mutex_unlock(&mutex);                
    }
    
       
    
};


template <typename T>
class retained_atomic_ptr
{
public:
    typedef T* value_type;
    
private:
    pthread_mutex_t mutex;
    volatile value_type value;
    
public:
    retained_atomic_ptr()
    {
        value = NULL;
        pthread_mutex_init(&mutex, NULL);
    }
    
    retained_atomic_ptr(value_type val)
    {
        pthread_mutex_init(&mutex, NULL);
    }
    
    ~retained_atomic_ptr()
    {
        pthread_mutex_destroy(&mutex);
        [value release];
    }
    
    value_type get()
    {
        value_type tmp;
        pthread_mutex_lock(&mutex);
        tmp = value;
        pthread_mutex_unlock(&mutex);
        return tmp;
    }
    
    void set(value_type right) 
    {
        pthread_mutex_lock(&mutex);
        [right retain];
        [value release];
        value=right;    
        pthread_mutex_unlock(&mutex);
    }
};





